/*
 * Decompiled with CFR 0.152.
 */
package net.sqf.utils.process.queues;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import net.sqf.utils.process.queues.ComplexTask;
import net.sqf.utils.process.queues._Task;
import net.sqf.utils.process.queues.listeners.QueueCancelListener;
import net.sqf.utils.process.queues.listeners.QueueListener;

public class SubQueue<Input, Output> {
    private ArrayList<_Task> tasks = new ArrayList();
    private ArrayList<QueueListener> startListener = new ArrayList();
    private ArrayList<QueueListener> endListener = new ArrayList();
    private ArrayList<QueueListener> taskListener = new ArrayList();
    private ArrayList<QueueListener> progressListener = new ArrayList();
    private ArrayList<QueueCancelListener> cancelListener = new ArrayList();
    private Output output = null;
    private final Class<Input> inputClass;
    private final Class<Output> outputClass;
    private boolean isInProcess = false;

    public SubQueue(Class<Input> inputClass, Class<Output> outputClass) {
        this.inputClass = inputClass;
        this.outputClass = outputClass;
    }

    public SubQueue(ArrayList<_Task> tasks, Class<Input> inputClass, Class<Output> outputClass) {
        this(inputClass, outputClass);
        this.addAllTasks(tasks);
    }

    public void addAllTasks(ArrayList<_Task> tasks) {
        Iterator<_Task> iterator = tasks.iterator();
        while (iterator.hasNext()) {
            this.addTask(iterator.next());
        }
    }

    public void addAllTasks(SubQueue queue) {
        this.addAllTasks(queue.getTasks());
    }

    public void addTask(_Task task) {
        this.tasks.add(task);
    }

    protected ArrayList<_Task> getTasks() {
        return this.tasks;
    }

    public void start(Input input) {
        this.isInProcess = true;
        _Task firstTask = this.tasks.get(0);
        int i = 0;
        for (final _Task task : this.tasks) {
            final boolean isLast = i + 1 >= this.tasks.size();
            final _Task nextTask = isLast ? null : this.tasks.get(i + 1);
            task.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (ComplexTask.isTaskDone(evt) && isLast) {
                        try {
                            Object output = task.getOutput();
                            if (!SubQueue.this.outputClass.isInstance(output)) {
                                throw new Exception("Cast error");
                            }
                            SubQueue.this.output = SubQueue.this.outputClass.cast(output);
                        }
                        catch (Exception e) {
                            SubQueue.this.cancel(e);
                        }
                        SubQueue.this.processEndListener(task);
                    } else if (ComplexTask.isTaskDone(evt) && !isLast) {
                        SubQueue.this.processTaskListener(nextTask);
                        try {
                            nextTask.start(task.getOutput());
                        }
                        catch (Exception e) {
                            SubQueue.this.cancel(e);
                        }
                    } else if (evt.getPropertyName().equals("progress")) {
                        SubQueue.this.processProgressListener(task);
                    }
                }
            });
            ++i;
        }
        this.processStartListener(firstTask);
        firstTask.start(input);
    }

    private void cancel(Exception e) {
        this.processCancelListener(e);
    }

    public Output getOutput() {
        return this.output;
    }

    public Class getOutputClass() {
        return this.outputClass;
    }

    public Class getInputClass() {
        return this.inputClass;
    }

    public int getProgress() {
        int progresSum = 0;
        int taskCount = this.tasks.size();
        for (_Task task : this.tasks) {
            progresSum += task.getProgress();
        }
        return progresSum / taskCount;
    }

    public void addStartListener(QueueListener listener) {
        this.startListener.add(listener);
    }

    private void processStartListener(_Task currentTask) {
        Iterator<QueueListener> iterator = this.startListener.iterator();
        while (iterator.hasNext()) {
            iterator.next().process(currentTask);
        }
    }

    public void addEndListener(QueueListener listener) {
        this.endListener.add(listener);
    }

    private void processEndListener(_Task currentTask) {
        Iterator<QueueListener> iterator = this.endListener.iterator();
        while (iterator.hasNext()) {
            iterator.next().process(currentTask);
        }
        this.isInProcess = false;
    }

    public void addTaskListener(QueueListener listener) {
        this.taskListener.add(listener);
    }

    private void processTaskListener(_Task currentTask) {
        Iterator<QueueListener> iterator = this.taskListener.iterator();
        while (iterator.hasNext()) {
            iterator.next().process(currentTask);
        }
    }

    public void addProgressListener(QueueListener listener) {
        this.progressListener.add(listener);
    }

    private void processProgressListener(_Task currentTask) {
        Iterator<QueueListener> iterator = this.progressListener.iterator();
        while (iterator.hasNext()) {
            iterator.next().process(currentTask);
        }
    }

    public void addCancelListener(QueueCancelListener listener) {
        this.cancelListener.add(listener);
    }

    private void processCancelListener(Exception e) {
        Iterator<QueueCancelListener> iterator = this.cancelListener.iterator();
        while (iterator.hasNext()) {
            iterator.next().process(e);
        }
        this.isInProcess = false;
    }

    public boolean isInProgress() {
        return this.tasks.get(this.tasks.size() - 1).isFinished();
    }

    public void waitForOutput() {
        this.waitForOutput(500);
    }

    public void waitForOutput(int interval) {
        this.waitForOutput(interval, 0);
    }

    public void waitForOutput(int interval, int maxTime) {
        for (int time = 0; this.isInProgress() || time > maxTime; time += interval) {
            try {
                Thread.sleep(interval);
                continue;
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }
}

