/*
 * Decompiled with CFR 0.152.
 */
package net.sqf.utils.process.queues;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.SwingWorker;
import net.sqf.utils.process.queues.SubQueue;
import net.sqf.utils.process.queues._Task;
import net.sqf.utils.process.queues.listeners.QueueCancelListener;
import net.sqf.utils.process.queues.listeners.QueueListener;

public abstract class ComplexTask<Input, SubQueInput, SubQueOutput, Output>
implements _Task<Input, Output> {
    private final SubQueue<SubQueInput, SubQueOutput> subQueue;
    private final String title;
    private final Task task;
    private Input input;
    private Output output;
    private Exception cancelException = null;
    private boolean isCanceled = false;
    private boolean isProcessing;
    private String progressTitle = "";

    public ComplexTask(String title, SubQueue<SubQueInput, SubQueOutput> subQue) {
        this.subQueue = subQue;
        this.title = title;
        this.task = new Task();
    }

    @Override
    public void start(Input input) {
        this.input = input;
        this.subQueue.addProgressListener(new QueueListener(){

            @Override
            public void process(_Task currentTask) {
                ComplexTask.this.progressTitle = currentTask.toString();
                ComplexTask.this.task.setProgressState(ComplexTask.this.subQueue.getProgress());
            }
        });
        this.subQueue.addCancelListener(new QueueCancelListener(){

            @Override
            public void process(Exception e) {
                ComplexTask.this.cancel(e);
            }
        });
        this.task.execute();
    }

    private void cancel(Exception e) {
        this.cancelException = e;
        this.isCanceled = true;
        this.task.cancel(true);
    }

    public abstract SubQueInput preProcess(Input var1) throws Exception;

    public abstract Output postProcess(SubQueOutput var1);

    @Override
    public Output getOutput() throws Exception {
        if (this.isCanceled) {
            throw this.cancelException;
        }
        return this.output;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.task.addPropertyChangeListener(listener);
    }

    @Override
    public int getProgress() {
        return this.task.getProgress();
    }

    public void setProgress(int progress) {
    }

    @Override
    public boolean isFinished() {
        return this.task.getState().equals((Object)SwingWorker.StateValue.DONE);
    }

    public static boolean isTaskDone(PropertyChangeEvent evt) {
        Object newValue = evt.getNewValue();
        String property = evt.getPropertyName();
        return SwingWorker.StateValue.DONE.equals(newValue) && property.equals("state");
    }

    public static boolean isTaskStarted(PropertyChangeEvent evt) {
        Object newValue = evt.getNewValue();
        String property = evt.getPropertyName();
        return SwingWorker.StateValue.STARTED.equals(newValue) && property.equals("state");
    }

    public String toString() {
        return String.valueOf(this.title) + "... " + this.progressTitle;
    }

    @Override
    public Class getInputClass() {
        return this.input.getClass();
    }

    @Override
    public Class getOutputClass() {
        return this.output.getClass();
    }

    private class Task
    extends SwingWorker<Void, Void> {
        private Task() {
        }

        @Override
        protected Void doInBackground() {
            try {
                Object tempValue = ComplexTask.this.preProcess(ComplexTask.this.input);
                ComplexTask.this.isProcessing = true;
                ComplexTask.this.subQueue.addEndListener(new QueueListener(){

                    @Override
                    public void process(_Task currentTask) {
                        ComplexTask.this.output = ComplexTask.this.postProcess(ComplexTask.this.subQueue.getOutput());
                        ComplexTask.this.isProcessing = false;
                    }
                });
                ComplexTask.this.subQueue.start(tempValue);
                while (ComplexTask.this.isProcessing) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.setProgress(100);
                return null;
            }
            catch (Exception e) {
                ComplexTask.this.cancel(e);
                return null;
            }
        }

        @Override
        public void done() {
            this.setProgress(100);
        }

        public void setProgressState(int progress) {
            this.setProgress(progress);
        }
    }
}

