<?xml version="1.0" encoding="UTF-8"?>
<schema xmlns="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2" xmlns:sqf="http://www.schematron-quickfix.com/validator/process" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:es="http://www.escali.schematron-quickfix.com/" xmlns:xs="http://www.w3.org/2001/XMLSchema">
    <ns prefix="html" uri="http://www.w3.org/1999/xhtml"/>
    <pattern>
        <rule context="html:date">
            <let name="date" value="xs:date(@date)"/>
            <let name="format" value="'[MNn] [D0], [Y0000]'"/>
            <assert test="replace(format-date($date, $format), '\s', '') = replace(@title, '\s', '')"  sqf:fix="reformat setNewDate">The <name path="@title"/> attribute should describe the date defined by the <name path="@date"/> attribute. The format should be Monthname Day, Year (today: <value-of select="format-date(current-date(), $format)"/>).</assert>
            <sqf:fix id="reformat">
                <sqf:description>
                    <sqf:title>Set a new <name path="@title"/> attribute, using the value of the <name path="@date"/> attribute.</sqf:title>
                </sqf:description>
                <sqf:replace match="@title" target="title">
                    <value-of select="format-date($date, $format)"/>
                </sqf:replace>
            </sqf:fix>
            <sqf:fix id="setNewDate">
                <sqf:description>
                    <sqf:title>Set a new date for the <name path="@date"/> attribute.</sqf:title>
                </sqf:description>
                <sqf:user-entry ref="newdate">
                    <sqf:description>
                        <sqf:title>Enter a new date.</sqf:title>
                    </sqf:description>
                </sqf:user-entry>
                <sqf:param name="newdate" as="xs:date"/>
                <sqf:replace match="@date" target="date">
                    <value-of select="$newdate"/>
                </sqf:replace>
                <sqf:replace match="@title" target="title">
                    <value-of select="format-date($newdate, $format)"/>
                </sqf:replace>
            </sqf:fix>
        </rule>
    </pattern>
</schema>
