<?xml version="1.0" encoding="UTF-8"?>
<!--  
    Copyright (c) 2014 Nico Kutscherauer
        
    This file is part of Escali Schematron.
    
    Escali Schematron is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
    
    Escali Schematron is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    You should have received a copy of the GNU General Public License
    along with Escali Schematron.  If not, see http://www.gnu.org/licenses/gpl-3.0.

-->
<xsl:stylesheet xmlns="http://www.w3.org/1999/xhtml" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:es="http://www.escali.schematron-quickfix.com/" xmlns:sqf="http://www.schematron-quickfix.com/validator/process" xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" exclude-result-prefixes="xs xd svrl es" version="2.0">
    
    <xd:doc scope="stylesheet">
        <xd:desc>
            <xd:p><xd:b>Created on:</xd:b> Nov 19, 2013</xd:p>
            <xd:p><xd:b>Author:</xd:b> Nico Kutscherauer</xd:p>
        </xd:desc>
    </xd:doc>
    
    <xd:doc scope="version">
        <xd:desc>
            <xd:p>Version information</xd:p>
            <xd:ul>
                <xd:li>
                    <xd:p>2014-03-14</xd:p>
                    <xd:ul>
                        <xd:li>
                            <xd:p>publishing version</xd:p>
                        </xd:li>
                    </xd:ul>
                </xd:li>
            </xd:ul>
        </xd:desc>
    </xd:doc>
    
    <xsl:output method="xhtml" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd"/>
    <xsl:variable name="title">
        <xsl:value-of select=" if (/svrl:schematron-output/@title != '') 
                             then (/svrl:schematron-output/@title) 
                             else ('Schematron report')"/>
        <xsl:text> – generated by Escali Schematron</xsl:text>
    </xsl:variable>




    <xsl:template match="/">
        <html>
            <head>
                <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
                <meta name="robots" content="noindex,follow"/>
                <link href="{resolve-uri('../../html/sqf.css')}" rel="stylesheet" type="text/css"/>
                <link href="{resolve-uri('../../html/sqf-logo-tiny.ico')}" rel="icon" type="image/x-icon"/>
                <link href="{resolve-uri('../../html/sqf-logo-tiny.ico')}" rel="shortcut icon" type="image/x-icon"/>
                <title>
                    <xsl:value-of select="$title"/>
                </title>
            </head>
            <body>
                <div class="menu">
                    <a href="index.html">
                        <div id="logo">
                            <p/>
                        </div>
                    </a>
                    <!--<div class="menu-links">
                        <div class="menu-button">
                            <a class="menu" href="#">Overview</a>
                        </div>
                        <xsl:for-each select="/svrl:schematron-output/svrl:active-pattern">
                            
                        </xsl:for-each>
                        <!-\-<xsl:for-each select="/svrl:schematron-output/svrl:active-pattern">
                            <div class="menu-button">
                                <a class="menu" href="{@id}.html">
                                    <xsl:value-of select="@id"/>
                                </a>
                            </div>
                        </xsl:for-each>-\->
                    </div>-->
                </div>
                <!--<div class="sub-menu">
                    <!-\-<div class="menu-button">
                        <a class="menu" href="about/team.html">Team</a>
                    </div>-\->
                </div>-->
                <div>
                    <div class="deco-hor" xml:space="preserve"><p/></div>
                    <div class="deco-ver" xml:space="preserve"><p/></div>
                    <div class="deco-body" xml:space="preserve"><p/></div>
                </div>
                <div class="body">
                    <div>
                        <h1>
                            <xsl:value-of select="$title"/>
                        </h1>
                        <table class="default" cellspacing="0" cellpadding="0">
                            <tbody>
                                <tr>
                                    <th>
                                        <p>Source document:</p>
                                    </th>
                                    <xsl:variable name="instance" select="/svrl:schematron-output/sqf:topLevel/@instance"/>
                                    <td>
                                        <p>
                                            <a href="{$instance}">
                                                <xsl:value-of select="tokenize($instance, '/')[last()]"/>
                                            </a>
                                        </p>
                                    </td>
                                </tr>
                                <tr>
                                    <th>
                                        <p>Schematron schema:</p>
                                    </th>
                                    <xsl:variable name="schema" select="/svrl:schematron-output/sqf:topLevel/@schema"/>
                                    <td>
                                        <p>
                                            <a href="{$schema}">
                                                <xsl:value-of select="tokenize($schema, '/')[last()]"/>
                                            </a>
                                        </p>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                        <xsl:variable name="firstPattern" select="/svrl:schematron-output/svrl:active-pattern[1]"/>
                        <xsl:for-each-group select="/svrl:schematron-output/svrl:*[. >> $firstPattern or svrl:active-pattern]" group-starting-with="svrl:active-pattern">
                            <div id="{@id}" class="section">
                                <h2>
                                    <xsl:value-of select=" if (@id) then (@id) else (concat('Pattern ', position()))"/>
                                </h2>
                                <table class="default" cellspacing="0">
                                    <col width="15%"/>
                                    <col width="5%"/>
                                    <col width="10%"/>
                                    <col width="20%"/>
                                    <col width="50%"/>
                                    <thead>
                                        <tr>
                                            <th/>
                                            <th colspan="3">
                                                <p>ID</p>
                                            </th>
                                            <th>
                                                <p>Description</p>
                                            </th>
                                        </tr>
                                    </thead>
                                    <xsl:for-each-group select="current-group()[self::svrl:fired-rule]" group-by="@es:id">
                                        <xsl:variable name="rule-content" as="node()*">
                                            <xsl:for-each select="current-group()">
                                                <xsl:variable name="nextRule" select="following-sibling::svrl:fired-rule[1]"/>
                                                <xsl:sequence select=" if ($nextRule) 
                                                                     then (following-sibling::*[self::svrl:failed-assert|self::svrl:successful-report]
                                                                                               [. &lt;&lt; $nextRule]) 
                                                                     else (following-sibling::*[self::svrl:failed-assert|self::svrl:successful-report])"/>
                                            </xsl:for-each>
                                        </xsl:variable>
                                        <xsl:if test="$rule-content">
                                            <tbody>
                                                <tr>
                                                    <th>
                                                        <p>[fired-rule]</p>
                                                    </th>
                                                    <td colspan="3">
                                                        <p>
                                                            <span class="icode-none">
                                                                <xsl:value-of select="@context"/>
                                                            </span>
                                                        </p>
                                                    </td>
                                                    <td>
                                                        <p>Locations:</p>
                                                        <xsl:for-each-group select="$rule-content" group-by="@location">
                                                            <p>
                                                                <span class="icode-none">
                                                                    <xsl:value-of select="current-grouping-key()"/>
                                                                </span>
                                                            </p>
                                                        </xsl:for-each-group>
                                                    </td>
                                                </tr>
                                                <xsl:apply-templates select="$rule-content"/>
                                            </tbody>
                                            <tbody>
                                                <tr>
                                                    <td colspan="3"/>
                                                </tr>
                                            </tbody>
                                        </xsl:if>
                                    </xsl:for-each-group>
                                </table>
                            </div>
                        </xsl:for-each-group>
                    </div>
                </div>
            </body>
        </html>
    </xsl:template>

    <xsl:template match="svrl:failed-assert | svrl:successful-report">
        <tr title="{@location}">
            <th>
                <p>
                    <xsl:text>[</xsl:text>
                    <xsl:value-of select="local-name()"/>
                    <xsl:text>]</xsl:text>
                </p>
            </th>
            <td colspan="3">
                <p>
                    <span class="icode-none">
                        <xsl:value-of select="@test"/>
                    </span>
                </p>
            </td>
            <td>
                <p>
                    <xsl:apply-templates select="svrl:text"/>
                </p>
            </td>

        </tr>


        <xsl:apply-templates select="sqf:fix"/>


    </xsl:template>

    <xsl:template match="sqf:fix">


        <tr>
            <th/>
            <th>
                <p>
                    <xsl:text>[</xsl:text>
                    <xsl:value-of select="local-name()"/>
                    <xsl:text>]</xsl:text>
                </p>
            </th>
            <td colspan="2">
                <p>
                    <span class="icode-none">
                        <xsl:value-of select="@id"/>
                    </span>
                </p>
            </td>
            <td>
                <xsl:apply-templates select="sqf:description"/>
            </td>
        </tr>


        <xsl:apply-templates select="sqf:user-entry"/>
    </xsl:template>

    <xsl:template match="sqf:user-entry">
        <tr>
            <th/>
            <th/>
            <th>
                <p>
                    <xsl:text>[</xsl:text>
                    <xsl:value-of select="local-name()"/>
                    <xsl:text>]</xsl:text>
                </p>
            </th>
            <td>
                <p>
                    <span class="icode-none">
                        <xsl:value-of select="sqf:param/@name"/>
                    </span>
                </p>
            </td>
            <td>
                <xsl:apply-templates select="sqf:description"/>
            </td>
        </tr>
    </xsl:template>

    <xsl:template match="svrl:text">
        <p>
            <xsl:value-of select="."/>
        </p>
    </xsl:template>

</xsl:stylesheet>
