<?xml version="1.0" encoding="UTF-8"?>
<schema xmlns="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2" xmlns:sqf="http://www.schematron-quickfix.com/validator/process">
    <ns uri="http://www.w3.org/1999/xhtml" prefix="html"/>
    <title>Two different language attributes.</title>
    <pattern>
        <rule context="html:html">
            <assert test="@lang" sqf:fix="lang lang_xml_lang" role="error">The attribute "lang" is missing.</assert>
            <assert test="@xml:lang" sqf:fix="xml_lang lang_xml_lang" role="warn">The attribute "xml:lang" is missing.</assert>
            <assert test="@lang = @xml:lang" sqf:fix="lang xml_lang" role="warn"> The attributes "lang" and "xml:lang" should have the same value.</assert>
        </rule>
        <rule context="*[@xml:lang and @lang]" role="warn">
            <assert test="@lang = @xml:lang" sqf:fix="lang xml_lang"
                > The attributes "lang" and "xml:lang" should have the same value.</assert>
        </rule>
        <rule context="*[@lang]" role="info">
            <assert test="@xml:lang" sqf:fix="xml_lang"
                >The attribute "xml:lang" is missing.</assert>
        </rule>
        <rule context="*[@xml:lang]" role="fatal">
            <assert test="@lang" sqf:fix="lang">The attribute "lang" is missing.</assert>
        </rule>
    </pattern>
    <sqf:fixes>
        <sqf:fix id="lang" use-when="@xml:lang">
            <sqf:description>
                <sqf:p>Adds a "lang" attribute with the value "<value-of select="@xml:lang"/>".</sqf:p>
            </sqf:description>
            <sqf:add match="." axis="@" target="lang" node-type="attribute">
                <value-of select="@xml:lang"/>
            </sqf:add>
        </sqf:fix>
        <sqf:fix id="xml_lang" use-when="@lang">
            <sqf:description>
                <sqf:p>Adds a "xml:lang" attribute with the value "<value-of select="@lang"/>".</sqf:p>
            </sqf:description>
            <sqf:add match="." axis="@" target="xml:lang" node-type="attribute">
                <value-of select="@lang"/>
            </sqf:add>
        </sqf:fix>
        <sqf:fix id="lang_xml_lang">
            <sqf:description>
                <sqf:p>Adds a "xml:lang" and a "lang" attribute to the node.</sqf:p>
            </sqf:description>
            <sqf:user-entry ref="lang">
                <sqf:description>
                    <sqf:p>Enter the correct language code.</sqf:p>
                </sqf:description>
            </sqf:user-entry>
            <sqf:param name="lang" as="xs:string" required="yes"/>
            <sqf:add match="." axis="@" target="xml:lang" node-type="attribute"><value-of select="$lang"/></sqf:add>
            <sqf:add match="." axis="@" target="lang" node-type="attribute"><value-of select="$lang"/></sqf:add>
        </sqf:fix>
    </sqf:fixes>
</schema>